% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

function KeyboardInput

%% Display Setup Module

% Define display parameters

whichScreen = max(Screen('screens'));
p.ScreenDistance = 30; 	% in inches
p.ScreenHeight = 15; 	% in inches
p.ScreenGamma = 2;	% from monitor calibration
p.maxLuminance = 100; % from monitor calibration
p.ScreenBackground = 0.5;

% Open the display window and hide the mouse cursor

if exist('onCleanup', 'class'), oC_Obj = onCleanup(@()sca); end % close any pre-existing PTB Screen window
PsychImaging('PrepareConfiguration'); 
PsychImaging('AddTask', 'General', 'FloatingPoint32BitIfPossible');   % set up a 32-bit framebuffer
PsychImaging('AddTask', 'General', 'NormalizedHighresColorRange');
PsychImaging('AddTask', 'FinalFormatting', 'DisplayColorCorrection', 'SimpleGamma');  % setup Gamma correction method
[windowPtr p.ScreenRect] = PsychImaging('OpenWindow', whichScreen, p.ScreenBackground);  % open a display window
PsychColorCorrection('SetEncodingGamma', windowPtr, 1 / p.ScreenGamma);  % set Gamma for all color channels

% Get frame rate and set screen font

p.ScreenFrameRate = FrameRate(windowPtr);
Screen('TextFont', windowPtr, 'Times'); 
Screen('TextSize', windowPtr, 24);

%% Experimental Module

% Start experiment with instructions
str = 'Type letters or numbers. Press ESC to exit.';
DrawFormattedText(windowPtr, str, 'center', 'center', 1);
        % Draw Instruction text string centered in window
t0 = Screen('Flip', windowPtr);  
        % flip the text image into active buffer

% Show typed letter or number and time since onset of instruction
keys = [cellstr([num2str((0:9)'); char(97:122)']); 'esc'];
while 1
    KbReleaseWait; % avoid reading a single press repeatedly
    [key Secs] = WaitTill(keys);   % wait till response
    if strcmp(key, 'esc'), break; end
    if iscellstr(key), key = key{1}; end 
        % take the first in case of multiple keys
    str = sprintf('You typed: %s\n\nTime since instruction onset: %.3f s', key, Secs - t0);
    DrawFormattedText(windowPtr, str, 'center', ...
          'center', 1);
    Screen('Flip', windowPtr);
end

%% System Reinstatement Module

Priority(0);  % restore priority
sca; % close window and textures, restore color lookup table

